<?php
// /sorteio/api/update.php
header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');

$SECRET = 'CHANGE_ME_SECRET'; // <-- troque aqui
$stateFile = __DIR__ . '/state.json';

function respond($arr, $code = 200){
  http_response_code($code);
  echo json_encode($arr, JSON_UNESCAPED_UNICODE);
  exit;
}

$input = json_decode(file_get_contents('php://input'), true);
if (!$input) respond(["ok"=>false, "error"=>"invalid_json"], 400);

if (!isset($input["secret"]) || $input["secret"] !== $SECRET) {
  respond(["ok"=>false, "error"=>"unauthorized"], 401);
}

$action = $input["action"] ?? "";
$payload = $input["payload"] ?? null;

// Carrega estado atual
$state = [
  "updated_at" => time(),
  "entries" => [],
  "countdown" => ["running" => false, "ends_at" => 0, "duration" => 0],
  "command" => ["id" => 0, "type" => "", "payload" => null],
  "winner" => null
];

if (file_exists($stateFile)) {
  $raw = file_get_contents($stateFile);
  $cur = json_decode($raw, true);
  if (is_array($cur)) $state = array_replace_recursive($state, $cur);
}

// incrementa command id (pra display detectar mudança)
$state["command"]["id"] = intval($state["command"]["id"] ?? 0) + 1;

switch ($action) {
  case "load_entries":
    // payload: { entries: [{coupon,name,phone,store}, ...] }
    $entries = $payload["entries"] ?? [];
    if (!is_array($entries)) $entries = [];
    $state["entries"] = $entries;
    $state["winner"] = null;
    $state["command"]["type"] = "entries_loaded";
    $state["command"]["payload"] = ["count" => count($entries)];
    break;

  case "start_countdown":
    // payload: { duration: seconds }
    $duration = intval($payload["duration"] ?? 0);
    if ($duration < 0) $duration = 0;
    $state["countdown"]["running"] = $duration > 0;
    $state["countdown"]["duration"] = $duration;
    $state["countdown"]["ends_at"] = $duration > 0 ? (time() + $duration) : 0;
    $state["command"]["type"] = "countdown_started";
    $state["command"]["payload"] = ["duration" => $duration, "ends_at" => $state["countdown"]["ends_at"]];
    break;

  case "draw":
    // display faz a animação, mas o "seed" vem daqui
    $seed = random_int(1, 999999999);
    $state["winner"] = null;
    $state["command"]["type"] = "draw";
    $state["command"]["payload"] = ["seed" => $seed];
    break;

  case "set_winner":
    // payload: { winner: {coupon,name,phone,store} }
    $winner = $payload["winner"] ?? null;
    $state["winner"] = $winner;
    $state["command"]["type"] = "winner_set";
    $state["command"]["payload"] = $winner;
    break;

  case "reset":
    $state = [
      "updated_at" => time(),
      "entries" => [],
      "countdown" => ["running" => false, "ends_at" => 0, "duration" => 0],
      "command" => ["id" => intval($state["command"]["id"] ?? 0) + 1, "type" => "reset", "payload" => null],
      "winner" => null
    ];
    break;

  default:
    respond(["ok"=>false, "error"=>"unknown_action"], 400);
}

$state["updated_at"] = time();

// grava com lock
$fp = fopen($stateFile, 'c+');
if (!$fp) respond(["ok"=>false, "error"=>"cannot_open_state"], 500);

flock($fp, LOCK_EX);
ftruncate($fp, 0);
fwrite($fp, json_encode($state, JSON_UNESCAPED_UNICODE));
fflush($fp);
flock($fp, LOCK_UN);
fclose($fp);

respond(["ok"=>true, "state"=>$state]);
